﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.BusinessAHOBPR.Extensions;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public class BprDoDDeployment : IDeployment
    {
        public BprDoDDeployment()
        {
            branchOfService = string.Empty;
            dutyProjectCode = string.Empty;
            deploymentCountryCode = string.Empty;
            deploymentStartDate = string.Empty;
            deploymentEndDate = string.Empty;
        }

        public string branchOfService { get; set; }
        public string dutyProjectCode { get; set; }
        public string deploymentCountryCode { get; set; }
        public string deploymentStartDate { get; set; }
        public string deploymentEndDate { get; set; }

        public IDeployment Create(DoDDeploymentAdapter deployment)
        {
            if (deployment == null)
                throw new ArgumentNullException(nameof(deployment));
            this.dutyProjectCode = string.Empty;
            //A deploymentlocation will either have a country OR a major body of water code
            this.deploymentCountryCode = deployment.DeploymentCountry;
            this.deploymentStartDate = deployment.DeploymentStartDate.ToShortDateString();
            this.deploymentEndDate = deployment.DeploymentEndDate.ToShortDateString(); 
            this.branchOfService = deployment.BranchOfService.Code;
            return this;
        }

        
    }
}
